<?php
declare(strict_types=1);
require_once __DIR__ . '/core.php';
require_once __DIR__ . '/fetchers.php';

// بارگذاری آخرین مدیاها
$items = loadAllMedia();
usort($items, fn($a,$b) => strcmp($b['name'] ?? '', $a['name'] ?? ''));
$latest = array_slice($items, 0, 12);

// وضعیت فضای هاست
$disk = getHostDiskUsage();
?>
<!doctype html>
<html lang="fa">
<head>
    <meta charset="utf-8">
    <title>دانلودر چندپلاگینه</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="assets/styles.css">
    <!-- نسخه‌گذاری برای شکستن کش -->
    <script src="assets/scripts.js?v=20251111" defer></script>
</head>
<body>
<header>
    <h1>دانلودر چندپلاگینه</h1>
    <nav>
        <a href="gallery.php">گالری</a>
    </nav>
</header>

<main>
    <!-- نمایش فضای هاست -->
    <section class="card">
        <h2>فضای هاست</h2>
        <div class="disk-usage">
            <canvas id="diskGauge" width="200" height="200"></canvas>
            <div class="disk-info">
                <p>کل: <?php echo htmlspecialchars($disk['total_str']); ?></p>
                <p>استفاده‌شده: <?php echo htmlspecialchars($disk['used_str']); ?></p>
                <p>آزاد: <?php echo htmlspecialchars($disk['free_str']); ?></p>
            </div>
        </div>
    </section>

    <!-- فرم وارد کردن لینک (AJAX) -->
    <form id="downloadForm" class="top-form">
        <label for="url">لینک:</label>
        <input type="url" id="url" name="url" placeholder="https://..." required>
        <button type="submit">دانلود</button>
    </form>
    <p class="hint">لینک هر سایتی را وارد کن؛ اسکریپت پلاگین مناسب را انتخاب می‌کند.</p>

    <!-- نمایشگر پیشرفت دانلود -->
    <section id="progressSection" class="hidden">
        <h2 style="text-align:center;">پیشرفت دانلود</h2>
        <div class="gauges">
            <canvas id="speedGauge" width="200" height="200"></canvas>
            <canvas id="progressGauge" width="200" height="200"></canvas>
        </div>
        <div id="progressInfo" style="text-align:center;margin-top:12px;"></div>
    </section>

    <!-- مودال انتخاب نوع محتوا (شیشه‌ای) -->
    <div id="contentTypeModal" class="modal hidden" aria-hidden="true">
        <div class="modal-content">
            <h3>انتخاب نوع محتوا</h3>
            <p class="muted">نوع محتوای لینک را انتخاب کن:</p>
            <div style="margin-top:8px;">
                <select id="contentTypeSelect" class="glass-select">
                    <option value="image">تصاویر</option>
                    <option value="video">ویدئو</option>
                    <option value="audio">صوت</option>
                    <option value="gif">گیف</option>
                    <option value="pdf">PDF</option>
                    <option value="other">سایر</option>
                </select>
            </div>
            <div class="modal-actions" style="margin-top:12px;">
                <button id="contentTypeOk" class="secondary">ادامه</button>
                <button id="contentTypeCancel" class="secondary">انصراف</button>
            </div>
        </div>
    </div>

    <!-- نمایش آخرین مدیاها -->
    <?php if (!empty($latest)): ?>
        <section>
            <h2 style="text-align:center;">آخرین دانلودها</h2>
            <div class="grid">
                <?php foreach ($latest as $it): ?>
                    <div class="cell"
                         data-type="<?php echo htmlspecialchars($it['type']); ?>"
                         data-src="<?php echo htmlspecialchars($it['path']); ?>">
                        <?php if (($it['type'] ?? '') === 'video'): ?>
                            <video class="thumb-img" src="<?php echo htmlspecialchars($it['path']); ?>" muted playsinline></video>
                        <?php else: ?>
                            <img class="thumb-img" src="<?php echo htmlspecialchars($it['thumb'] ?: $it['path']); ?>" alt="thumb" loading="lazy">
                        <?php endif; ?>
                        <div class="name"><?php echo htmlspecialchars($it['title'] ?: basename($it['path'])); ?></div>
                    </div>
                <?php endforeach; ?>
            </div>
            <p style="text-align:center;margin-top:12px;">
                <a href="gallery.php">مشاهده همه در گالری</a>
            </p>
        </section>
    <?php endif; ?>
</main>
</body>
</html>