<?php
declare(strict_types=1);
require_once __DIR__ . '/core.php';
require_once __DIR__ . '/fetchers.php';

// بارگذاری آخرین مدیاها برای نمایش سریع
$items = loadAllMedia();
usort($items, fn($a,$b) => strcmp($b['name'] ?? '', $a['name'] ?? ''));
$latest = array_slice($items, 0, 12); // فقط ۱۲ آیتم آخر
?>
<!doctype html>
<html lang="fa">
<head>
  <meta charset="utf-8">
  <title>دانلودر چندپلاگینه</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="assets/styles.css">
</head>
<body>
  <header>
    <h1>دانلودر چندپلاگینه</h1>
    <nav>
      <a href="gallery.php">گالری</a>
    </nav>
  </header>

  <main>
    <!-- فرم وارد کردن لینک -->
    <form method="post" action="download.php" class="top-form">
      <label for="url">لینک:</label>
      <input type="url" id="url" name="url" placeholder="https://..." required>
      <button type="submit">ادامه</button>
    </form>
    <p class="hint">لینک هر سایتی را وارد کن؛ اسکریپت پلاگین مناسب را انتخاب می‌کند.</p>

    <!-- نمایش آخرین مدیاها -->
    <?php if (!empty($latest)): ?>
    <section>
      <h2 style="text-align:center;">آخرین دانلودها</h2>
      <div class="grid">
        <?php foreach ($latest as $it): ?>
          <div class="cell" data-type="<?php echo htmlspecialchars($it['type']); ?>" data-src="<?php echo htmlspecialchars($it['path']); ?>">
            <?php if (($it['type'] ?? '') === 'video'): ?>
              <video class="thumb-img" src="<?php echo htmlspecialchars($it['path']); ?>" muted playsinline></video>
            <?php else: ?>
              <img class="thumb-img" src="<?php echo htmlspecialchars($it['thumb'] ?: $it['path']); ?>" alt="thumb" loading="lazy">
            <?php endif; ?>
            <div class="name"><?php echo htmlspecialchars($it['title'] ?: basename($it['path'])); ?></div>
          </div>
        <?php endforeach; ?>
      </div>
      <p style="text-align:center;margin-top:12px;">
        <a href="gallery.php">مشاهده همه در گالری</a>
      </p>
    </section>
    <?php endif; ?>
  </main>
</body>
</html>
