<?php
declare(strict_types=1);
require_once __DIR__ . '/core.php';
require_once __DIR__ . '/fetchers.php';

$items = loadAllMedia();

// پارامترها
$perPage = (int)($_GET['perPage'] ?? 30);
$page    = max(1, (int)($_GET['page'] ?? 1));
$sort    = $_GET['sort'] ?? 'new';
$author  = trim($_GET['author'] ?? '');
$linkId  = trim($_GET['linkId'] ?? '');
$q       = trim($_GET['q'] ?? ''); // جستجو

// گروه‌بندی: دامنه → لینک‌ها
$grouped = [];
foreach ($items as $it) {
    $a = $it['author'] ?? 'unknown';
    $l = $it['linkId'] ?? 'link';
    if (!isset($grouped[$a])) $grouped[$a] = [];
    if (!isset($grouped[$a][$l])) $grouped[$a][$l] = [];
    $grouped[$a][$l][] = $it;
}

// فیلتر دامنه
if ($author !== '') {
    $items = [];
    if (isset($grouped[$author])) {
        if ($linkId !== '') {
            $items = $grouped[$author][$linkId] ?? [];
        } else {
            // فقط پروفایل لینک‌ها
            foreach ($grouped[$author] as $lid => $list) {
                $items[] = [
                    'author' => $author,
                    'linkId' => $lid,
                    'thumb'  => $list[0]['thumb'] ?? $list[0]['path'] ?? 'assets/profile-placeholder.png',
                    'count'  => $list[0]['count'] ?? count($list),
                    'size'   => $list[0]['size'] ?? 0,
                    'page'   => $list[0]['page'] ?? '',
                ];
            }
        }
    }
}

// فیلتر جستجو
if ($q !== '' && $linkId !== '') {
    $items = array_values(array_filter($items, function ($it) use ($q) {
        return mb_stripos($it['title'] ?? '', $q) !== false || mb_stripos($it['name'] ?? '', $q) !== false;
    }));
}

// مرتب‌سازی
switch ($sort) {
    case 'new':  usort($items, fn($a,$b) => strcmp($b['name'] ?? '', $a['name'] ?? '')); break;
    case 'old':  usort($items, fn($a,$b) => strcmp($a['name'] ?? '', $b['name'] ?? '')); break;
    case 'alpha':usort($items, fn($a,$b) => strcmp(mb_strtolower($a['title'] ?? ''), mb_strtolower($b['title'] ?? ''))); break;
    default:     usort($items, fn($a,$b) => strcmp($b['name'] ?? '', $a['name'] ?? '')); break;
}

// صفحه‌بندی فقط وقتی مدیا نمایش داده میشه
$total   = count($items);
$pages   = max(1, (int)ceil($total / $perPage));
$start   = ($page - 1) * $perPage;
$view    = ($linkId !== '') ? array_slice($items, $start, $perPage) : $items;

// تابع پروفایل دامنه (گرفتن یک thumbnail معقول)
function authorProfileThumb(array $links): string {
    foreach ($links as $list) {
        foreach ($list as $it) {
            if (!empty($it['thumb'])) return $it['thumb'];
            if (($it['type'] ?? '') === 'image' && !empty($it['path'])) return $it['path'];
        }
    }
    return 'assets/profile-placeholder.png';
}
?>
<!doctype html>
<html lang="fa">
<head>
  <meta charset="utf-8">
  <title>گالری رسانه‌ها</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="assets/styles.css">
  <style>
    body { font-family: sans-serif; }
    header { display:flex; align-items:center; justify-content:space-between; padding:10px 16px; }
    .grid { display:grid; grid-template-columns: repeat(auto-fill, minmax(200px,1fr)); gap:12px; padding:16px; }
    .cell { border:1px solid #e5e5e5; border-radius:8px; overflow:hidden; background:#fff; }
    .cell.profile { text-decoration:none; color:#222; }
    .thumb-img { width:100%; height:160px; object-fit:cover; display:block; background:#f3f3f3; }
    .name { padding:8px 10px; font-size:14px; line-height:1.5; word-break:break-word; }
    .top-form { display:flex; gap:8px; padding:0 16px; margin:10px 0; }
    .top-form input { flex:1; }
    .pagination { display:flex; gap:6px; justify-content:center; padding:12px; }
    .pagination a { padding:6px 10px; border:1px solid #ddd; border-radius:6px; text-decoration:none; color:#333; }
    .pagination a.active { background:#333; color:#fff; }
    .viewer { position:fixed; inset:0; background:rgba(0,0,0,0.9); display:flex; align-items:center; justify-content:center; z-index:9999; }
    .viewer.hidden { display:none; }
    #player { max-width: min(90vw, 1000px); max-height: 80vh; }
    #player img.fit, #player video.fit { max-width:100%; max-height:80vh; }
    #player img.zoomed { width:auto; height:auto; }
    .close, .nav, .delete { position:fixed; background:#222; color:#fff; border:none; border-radius:8px; padding:8px 12px; cursor:pointer; }
    .close { top:16px; right:16px; font-size:20px; }
    .nav.prev { left:16px; top:50%; transform:translateY(-50%); }
    .nav.next { right:16px; top:50%; transform:translateY(-50%); }
    .delete { bottom:20px; right:20px; }
  </style>
</head>
<body>
  <header>
    <h1>گالری</h1>
    <nav><a href="gallery.php">خانه</a> · <a href="index.php">دانلود جدید</a></nav>
  </header>

  <main>
    <!-- فرم وارد کردن لینک -->
    <form method="post" action="download.php" class="top-form">
      <input type="url" name="url" placeholder="https://..." required>
      <button type="submit">ادامه</button>
    </form>

    <!-- گالری -->
    <section class="grid">
      <?php if ($author === ''): ?>
        <!-- نمایش پروفایل دامنه‌ها -->
        <?php foreach ($grouped as $a => $links): ?>
          <a class="cell profile" href="?author=<?php echo urlencode($a); ?>">
            <img class="thumb-img" src="<?php echo htmlspecialchars(authorProfileThumb($links)); ?>" alt="profile" loading="lazy">
            <div class="name"><?php echo htmlspecialchars($a); ?> (<?php echo count($links); ?> لینک)</div>
          </a>
        <?php endforeach; ?>
      <?php elseif ($linkId === ''): ?>
        <!-- نمایش پروفایل لینک‌های یک دامنه -->
        <?php foreach ($items as $link): ?>
          <a class="cell profile" href="?author=<?php echo urlencode($author); ?>&linkId=<?php echo urlencode($link['linkId']); ?>">
            <img class="thumb-img" src="<?php echo htmlspecialchars($link['thumb']); ?>" alt="link" loading="lazy">
            <div class="name">
              لینک: <?php echo htmlspecialchars($link['linkId']); ?><br>
              آدرس: <?php echo htmlspecialchars($link['page']); ?><br>
              تعداد: <?php echo (int)$link['count']; ?> · حجم: <?php echo round(((float)$link['size'])/1024/1024,2); ?> MB
            </div>
          </a>
        <?php endforeach; ?>
        <p style="text-align:center;margin-top:12px;"><a href="gallery.php">بازگشت به لیست دامنه‌ها</a></p>
      <?php else: ?>
        <!-- نمایش مدیاهای یک لینک -->
        <?php foreach ($view as $it): ?>
          <div class="cell" data-type="<?php echo htmlspecialchars($it['type']); ?>" data-src="<?php echo htmlspecialchars($it['path']); ?>">
            <?php if (($it['type'] ?? '') === 'video'): ?>
              <video class="thumb-img" src="<?php echo htmlspecialchars($it['path']); ?>" muted playsinline></video>
            <?php else: ?>
              <img class="thumb-img" src="<?php echo htmlspecialchars(($it['thumb'] ?: $it['path'])); ?>" alt="thumb" loading="lazy">
            <?php endif; ?>
            <div class="name"><?php echo htmlspecialchars(($it['title'] ?: basename($it['path']))); ?></div>
          </div>
        <?php endforeach; ?>

        <!-- صفحه‌بندی -->
        <div class="pagination">
          <?php for($i=1;$i<=$pages;$i++): ?>
            <a href="?page=<?php echo $i; ?>&perPage=<?php echo $perPage; ?>&sort=<?php echo urlencode($sort); ?>&author=<?php echo urlencode($author); ?>&linkId=<?php echo urlencode($linkId); ?>&q=<?php echo urlencode($q); ?>"
               class="<?php if($i==$page) echo 'active'; ?>"><?php echo $i; ?></a>
          <?php endfor; ?>
        </div>

        <p style="text-align:center;margin-top:12px;">
          <a href="?author=<?php echo urlencode($author); ?>">بازگشت به لینک‌های دامنه</a>
        </p>
      <?php endif; ?>
    </section>

    <!-- ویوئر -->
    <div id="viewer" class="viewer hidden" aria-hidden="true">
      <button id="closeBtn" class="close" title="بستن">×</button>
      <button id="prevBtn" class="nav prev" title="قبلی">‹</button>
      <button id="nextBtn" class="nav next" title="بعدی">›</button>
      <div id="player"></div>
      <button id="deleteBtn" class="delete" title="حذف">حذف</button>
    </div>
  </main>

  <script>
  const viewer = document.getElementById('viewer');
  const player = document.getElementById('player');
  const closeBtn = document.getElementById('closeBtn');
  const prevBtn = document.getElementById('prevBtn');
  const nextBtn = document.getElementById('nextBtn');
  const deleteBtn = document.getElementById('deleteBtn');
  const cells = Array.from(document.querySelectorAll('.cell[data-type]'));
  let currentIndex = -1;

  function showItem(index) {
    if (!cells.length) return;
    if (index < 0) index = cells.length - 1;
    if (index >= cells.length) index = 0;
    currentIndex = index;

    const cell = cells[index];
    const type = cell.dataset.type;
    const src  = cell.dataset.src;

    viewer.classList.remove('hidden');
    viewer.setAttribute('aria-hidden', 'false');
    player.innerHTML = '';

    if (type === 'image' || type === 'gif') {
      const img = document.createElement('img');
      img.src = src;
      img.className = 'fit';
      img.alt = 'media';
      player.appendChild(img);

      img.addEventListener('click', () => {
        if (img.classList.contains('zoomed')) {
          img.classList.remove('zoomed');
          img.classList.add('fit');
        } else {
          img.classList.remove('fit');
          img.classList.add('zoomed');
        }
      });
    } else if (type === 'video') {
      const vid = document.createElement('video');
      vid.src = src;
      vid.controls = true;
      vid.autoplay = true;
      vid.playsInline = true;
      vid.className = 'fit';
      player.appendChild(vid);
    } else {
      const a = document.createElement('a');
      a.href = src;
      a.textContent = 'دانلود فایل';
      a.target = '_blank';
      player.appendChild(a);
    }

    deleteBtn.dataset.src = src;
  }

  cells.forEach((cell, i) => {
    cell.addEventListener('click', e => {
      e.preventDefault();
      showItem(i);
    });
  });

  prevBtn.addEventListener('click', () => showItem(currentIndex - 1));
  nextBtn.addEventListener('click', () => showItem(currentIndex + 1));

  closeBtn.addEventListener('click', () => {
    viewer.classList.add('hidden');
    viewer.setAttribute('aria-hidden', 'true');
    player.innerHTML = '';
  });

  viewer.addEventListener('click', e => {
    if (e.target === viewer) {
      viewer.classList.add('hidden');
      viewer.setAttribute('aria-hidden', 'true');
      player.innerHTML = '';
    }
  });

  // حذف فایل
  deleteBtn.addEventListener('click', () => {
    if (!deleteBtn.dataset.src) return;
    if (!confirm('آیا مطمئنی می‌خواهی حذف کنی؟')) return;
    fetch('delete.php', {
      method: 'POST',
      headers: {'Content-Type': 'application/x-www-form-urlencoded'},
      body: 'file=' + encodeURIComponent(deleteBtn.dataset.src)
    }).then(r => r.text()).then(txt => {
      alert(txt);
      location.reload();
    }).catch(err => alert('خطا در حذف: ' + err));
  });

  // ناوبری با کیبورد
  document.addEventListener('keydown', e => {
    if (viewer.classList.contains('hidden')) return;
    if (e.key === 'Escape') { closeBtn.click(); }
    else if (e.key === 'ArrowLeft') { prevBtn.click(); }
    else if (e.key === 'ArrowRight') { nextBtn.click(); }
  });
  </script>
</body>
</html>
