<?php
declare(strict_types=1);

require_once __DIR__ . '/core.php';
require_once __DIR__ . '/fetchers.php'; // رجیستری پلاگین‌ها و getFetcherForUrl

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: index.php');
    exit;
}

$url         = trim($_POST['url'] ?? '');
$contentType = trim($_POST['contentType'] ?? ''); // فقط برای GenericFetcher استفاده می‌شود

if (!$url) {
    http_response_code(400);
    echo '❌ لینک معتبر وارد کنید.';
    exit;
}

try {
    // انتخاب پلاگین مناسب از رجیستری
    $fetcherClass = getFetcherForUrl($url);

    // اگر هیچ پلاگینی اعلام آمادگی نکرد، حالت Generic با انتخاب نوع محتوا
    if (!$fetcherClass) {
        if ($contentType === '') {
            ?>
            <!doctype html>
            <html lang="fa">
            <head>
              <meta charset="utf-8">
              <title>انتخاب نوع محتوا</title>
              <link rel="stylesheet" href="assets/styles.css">
            </head>
            <body>
              <main>
                <h2>انتخاب نوع محتوا برای دانلود</h2>
                <form method="post" action="download.php" class="filter-form">
                  <input type="hidden" name="url" value="<?php echo htmlspecialchars($url); ?>">
                  <label>نوع محتوا:</label>
                  <select name="contentType" required>
                    <option value="image">تصاویر</option>
                    <option value="video">ویدئو</option>
                    <option value="audio">صوت</option>
                    <option value="gif">گیف</option>
                    <option value="pdf">PDF</option>
                  </select>
                  <button type="submit">دانلود</button>
                </form>
              </main>
            </body>
            </html>
            <?php
            exit;
        }
        // استفاده از GenericFetcher وقتی پلاگین اختصاصی وجود ندارد
        if (!class_exists('GenericFetcher')) {
            throw new RuntimeException('GenericFetcher در دسترس نیست.');
        }
        $fetcherClass = GenericFetcher::class;
        $medias = $fetcherClass::fetchMedia($url, $contentType);
    } else {
        // فراخوانی پلاگین انتخاب شده
        // اگر پلاگین Generic باشد و contentType نیاز دارد، آن را پاس بده
        if ($fetcherClass === GenericFetcher::class) {
            if ($contentType === '') {
                ?>
                <!doctype html>
                <html lang="fa">
                <head>
                  <meta charset="utf-8">
                  <title>انتخاب نوع محتوا</title>
                  <link rel="stylesheet" href="assets/styles.css">
                </head>
                <body>
                  <main>
                    <h2>انتخاب نوع محتوا برای دانلود</h2>
                    <form method="post" action="download.php" class="filter-form">
                      <input type="hidden" name="url" value="<?php echo htmlspecialchars($url); ?>">
                      <label>نوع محتوا:</label>
                      <select name="contentType" required>
                        <option value="image">تصاویر</option>
                        <option value="video">ویدئو</option>
                        <option value="audio">صوت</option>
                        <option value="gif">گیف</option>
                        <option value="pdf">PDF</option>
                      </select>
                      <button type="submit">دانلود</button>
                    </form>
                  </main>
                </body>
                </html>
                <?php
                exit;
            }
            $medias = $fetcherClass::fetchMedia($url, $contentType);
        } else {
            $medias = $fetcherClass::fetchMedia($url);
        }
    }

    // مسیرهای نویسنده و شناسه لینک براساس URL ورودی (ثابت برای همه پلاگین‌ها)
    $author = sanitizeSlug(parse_url($url, PHP_URL_HOST) ?? 'unknown');
    $pathParts = explode('/', trim(parse_url($url, PHP_URL_PATH) ?? '', '/'));
    $linkId = sanitizeSlug(end($pathParts) ?: 'link');
    [$userMediaPath, $userThumbPath, $userMetaPath] = ensureLinkDirs($author, $linkId);

    $saved = [];

    foreach ($medias as $m) {
        // Skip اگر از قبل دانلود شده
        if (alreadyDownloaded($m['url'])) continue;

        $base   = sanitizeSlug($m['title'] ?? 'media');
        $type   = $m['type'] ?? 'image';
        $ext    = $m['ext'] ?: ($type === 'video' ? 'mp4' : ($type === 'image' ? 'jpg' : 'bin'));
        $hash   = md5($m['url']);

        $name = "{$base}_{$hash}.{$ext}";
        $dest = $userMediaPath . '/' . $name;

        // اگر نوع live باشد، فعلاً به‌صورت لینک ذخیره می‌کنیم یا می‌توان افزونه ضبط با ffmpeg اضافه کرد
        if ($type === 'live') {
            // برای نسخه‌ی پایه: فقط مرجع را ثبت کن و placeholder thumbnail بساز
            $dummy = $userMediaPath . '/' . "{$base}_{$hash}.txt";
            file_put_contents($dummy, "STREAM: " . $m['url']);
            $thumb = $userThumbPath . '/' . preg_replace('/\.[^.]+$/', '.jpg', $name);
            makePlaceholderThumb($thumb, 'live');
            $saved[] = [
                'file'   => "storage/media/$author/$linkId/" . basename($dummy),
                'thumb'  => "storage/thumbs/$author/$linkId/" . basename($thumb),
                'type'   => 'live',
                'source' => $m['url'],
                'author' => $author,
                'linkId' => $linkId,
                'title'  => $base,
            ];
            continue;
        }

        // دانلود فایل
        downloadFile($m['url'], $dest);

        // ساخت thumbnail
        $thumb = $userThumbPath . '/' . preg_replace('/\.[^.]+$/', '.jpg', $name);
        if ($type === 'image' || $type === 'gif') {
            makeThumb($dest, $thumb);
        } elseif ($type === 'video') {
            // تولید thumbnail ویدئو با ffmpeg
            $cmd = sprintf(
                'ffmpeg -y -ss 1 -i %s -vframes 1 -vf "scale=320:-1" %s 2>&1',
                escapeshellarg($dest),
                escapeshellarg($thumb)
            );
            exec($cmd, $out, $ret);
            if ($ret !== 0 || !file_exists($thumb)) {
                makePlaceholderThumb($thumb, 'video');
            }
        } else {
            makePlaceholderThumb($thumb, $type);
        }

        $saved[] = [
            'file'   => "storage/media/$author/$linkId/$name",
            'thumb'  => "storage/thumbs/$author/$linkId/" . basename($thumb),
            'type'   => $type,
            'source' => $m['url'],
            'author' => $author,
            'linkId' => $linkId,
            'title'  => $base,
        ];
    }

    // ذخیره متادیتا جمعی
    if (!empty($saved)) {
        $postPath = parse_url($url, PHP_URL_PATH) ?? '';
        $postId   = sanitizeSlug($postPath ?: 'post');

        $count = count($saved);
        $size  = 0;
        foreach ($saved as $it) {
            $path = __DIR__ . '/' . $it['file'];
            if (file_exists($path)) $size += filesize($path);
        }

        saveMeta($postId, [
            'source'        => $url,
            'downloaded_at' => date('c'),
            'items'         => $saved,
            'count'         => $count,
            'size'          => $size
        ], $author, $linkId);
    }

} catch (Throwable $e) {
    http_response_code(500);
    echo '❌ خطا: ' . htmlspecialchars($e->getMessage(), ENT_QUOTES, 'UTF-8');
    exit;
}

header('Location: gallery.php');
