<?php
declare(strict_types=1);

require_once __DIR__ . '/../core.php';

class MaturesPornFetcher implements SiteFetcher {
    public static function canHandle(string $url): bool {
        // صفحات فیلم در این دامنه
        return preg_match('~matures\.porn/(movie|videos)/~i', $url) === 1;
    }

    public static function fetchMedia(string $url): array {
        $html = httpGet($url, [
            "User-Agent: Mozilla/5.0 (MaturesFetcher/1.0)",
            "Accept: */*",
            "Referer: $url",
        ]);

        // PlayerJS: استخراج مقدار file یا sources
        // مثال‌های معمول:
        // new Playerjs({file:"https://cdn.example.com/video.mp4"});
        // new Playerjs({file:"https://.../master.m3u8"});
        // new Playerjs({sources:[{file:"..."},{file:"..."}]});
        $list = [];

        // حالت file:"..."
        if (preg_match('~Playerjs\s*\(\s*\{\s*[^}]*file\s*:\s*["\']([^"\']+)["\']~i', $html, $m)) {
            $vurl = html_entity_decode($m[1]);
            $list[] = self::makeItem($url, $vurl);
        }

        // حالت sources:[{file:"..."},...]
        if (preg_match('~sources\s*:\s*\[\s*\{[^}]*file\s*:\s*["\']([^"\']+)["\']~i', $html, $m2)) {
            $vurl2 = html_entity_decode($m2[1]);
            $list[] = self::makeItem($url, $vurl2);
        }

        // حالت تگ <source src="...">
        if (preg_match('~<source[^>]+src=["\']([^"\']+)["\']~i', $html, $m3)) {
            $vurl3 = html_entity_decode($m3[1]);
            $list[] = self::makeItem($url, $vurl3);
        }

        // یکتاسازی
        $seen = [];
        $uniq = [];
        foreach ($list as $it) {
            if (isset($seen[$it['url']])) continue;
            $seen[$it['url']] = true;
            $uniq[] = $it;
        }

        if (empty($uniq)) {
            throw new RuntimeException('❌ لینک ویدئو در PlayerJS یا سورس صفحه پیدا نشد.');
        }
        return $uniq;
    }

    private static function makeItem(string $pageUrl, string $videoUrl): array {
        $author = sanitizeSlug(parse_url($pageUrl, PHP_URL_HOST) ?? 'matures_porn');
        $title  = sanitizeSlug(basename(parse_url($pageUrl, PHP_URL_PATH) ?? 'video'));
        // اگر HLS باشد (m3u8)، همچنان به‌صورت video ذخیره می‌کنیم؛ دانلودر تصمیم می‌گیرد چگونه ذخیره کند
        $ext = pathinfo(parse_url($videoUrl, PHP_URL_PATH) ?? '', PATHINFO_EXTENSION) ?: 'mp4';
        return [
            'url'    => $videoUrl,
            'type'   => 'video',
            'author' => $author,
            'title'  => $title,
            'ext'    => $ext,
        ];
    }
}