<?php
declare(strict_types=1);

require_once __DIR__ . '/core.php';

// بارگذاری همه پلاگین‌ها
require_once __DIR__ . '/plugins/RedgifsFetcher.php';
require_once __DIR__ . '/plugins/GenericFetcher.php';
require_once __DIR__ . '/plugins/MaturesPornFetcher.php';
require_once __DIR__ . '/plugins/ChaturbateFetcher.php';
require_once __DIR__ . '/plugins/RedditFetcher.php';
require_once __DIR__ . '/plugins/EpornerFetcher.php'; // ← پلاگین جدید

/**
 * لیست همه‌ی پلاگین‌ها
 * هر پلاگین باید کلاس SiteFetcher را پیاده‌سازی کند
 */
$fetchers = [
    RedgifsFetcher::class,
    GenericFetcher::class,
    MaturesPornFetcher::class,
    ChaturbateFetcher::class,
    RedditFetcher::class,
    EpornerFetcher::class, // ← پلاگین جدید
];

/**
 * انتخاب پلاگین مناسب بر اساس لینک
 *
 * @param string $url لینک ورودی کاربر
 * @return string|null نام کلاس پلاگین یا null اگر هیچ پلاگینی سازگار نبود
 */
function getFetcherForUrl(string $url): ?string {
    global $fetchers;
    foreach ($fetchers as $f) {
        if ($f::canHandle($url)) {
            return $f;
        }
    }
    return null;
}

/**
 * گرفتن مدیا از لینک ورودی
 *
 * @param string $url لینک ورودی کاربر
 * @return array لیست مدیاهای استخراج‌شده
 * @throws RuntimeException اگر هیچ پلاگینی سازگار نبود یا مدیا پیدا نشد
 */
function fetchMediaFromUrl(string $url): array {
    $fetcherClass = getFetcherForUrl($url);
    if (!$fetcherClass) {
        throw new RuntimeException("❌ هیچ پلاگینی برای این لینک پیدا نشد: $url");
    }
    return $fetcherClass::fetchMedia($url);
}
